#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int is_prime(int x) {
    if (x < 2) return 0;
    for (int i = 2; i * i <= x; i++)
        if (x % i == 0)
            return 0;
    return 1;
}

int main(int argc, char *argv[]) {
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int N = atoi(argv[1]);
    int P = atoi(argv[2]);

    if (size != P) {
        MPI_Finalize();
        return 0;
    }

    int *v = malloc(N * sizeof(int));
    for (int i = 0; i < N; i++)
        v[i] = atoi(argv[i + 3]);

    /* împărțirea indicilor */
    int base = N / P;
    int rem = N % P;

    int start = rank * base + (rank < rem ? rank : rem);
    int count = base + (rank < rem ? 1 : 0);
    int end = start + count;

    int local_count = 0;
    int local_sum = 0;

    for (int i = start; i < end; i++) {
        if (is_prime(v[i])) {
            local_count++;
            local_sum += i;
        }
    }

    /* trimite rezultatele locale */
    if (rank != 0) {
        MPI_Send(&local_count, 1, MPI_INT, 0, 1, MPI_COMM_WORLD);
        MPI_Send(&local_sum, 1, MPI_INT, 0, 2, MPI_COMM_WORLD);
    }

    /* procesul 0 agregă și afișează */
    if (rank == 0) {
        int total_count = local_count;
        int total_sum = local_sum;

        for (int i = 1; i < P; i++) {
            int c, s;
            MPI_Recv(&c, 1, MPI_INT, i, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            MPI_Recv(&s, 1, MPI_INT, i, 2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            total_count += c;
            total_sum += s;
        }

        printf("%d %d\n", total_count, total_sum);
    }

    free(v);
    MPI_Finalize();
    return 0;
}
